* Appendices A and B
* MARY-ALICE DOYLE
* LAST EDITED: 02 October 2018

*********
* SETUP
*********
clear
*cd [specify filepath for working directory]
do ".\Stata files\Regression setup.do"

* drop respondents who do not own a credit card
drop if ccown==0
set more off

**********
* APPENDIX A
**********

* Figure A1
* monetary
tablecol q8g idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout q8g if idtag==1 [iw=w1] using ".\Excel output\Appendices A and B.xls", c(col) f(4) replace clab(A_monetary)

* monetary + non-monetary
tablecol q8h idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout q8h if idtag==1 [iw=w1] using ".\Excel output\Appendices A and B.xls", c(col) f(4) append clab(A_monetary_nonmonetary)

**********
* APPENDIX B
**********

* Graph B1
* How do you redeem your rewards?
tablecol q7a idtag if idtag==1 & ccreward==1 [pw=w1], colpct nofreq
quietly: tabout q7a if idtag==1 & ccreward==1 [iw=w1] using ".\Excel output\Appendices A and B.xls", c(col) f(4) append clab(B1)


clear
do ".\Stata files\Sensitivity analysis.do"

* Graph B2
* Distribution of net monetary benefits - by rewards points use assumption
forvalues i = 1/2 {
	egen netbenefitbins = cut(netbenefit11`i'1), at(-22000(20)16000)
	quietly: tabout netbenefitbins if idtag==1 [aw=w1] using ".\Excel output\Appendix B2.xls", f(4) c(col) append
	drop netbenefitbins
	}


* Graph B3 
* Distribution of net monetary benefits - by method of calculating annual card spending
forvalues i = 1/2 {
	egen netbenefitbins = cut(netbenefit`i'111), at(-22000(20)16000)
	quietly: tabout netbenefitbins if idtag==1 [aw=w1] using ".\Excel output\Appendix B3.xls", f(4) c(col) append
	drop netbenefitbins
	}
	


* Graph B4
* Distribution of net monetary benefits - by assumed alterantive interest rate
forvalues i = 1/3 {
	egen netbenefitbins = cut(netbenefit1`i'11), at(-22000(20)16000)
	quietly: tabout netbenefitbins if idtag==1 [aw=w1] using ".\Excel output\Appendix B4.xls", f(4) c(col) append
	drop netbenefitbins
	}
	

	


* Graph B5
* Distribution of net monetary benefit - by assumed frequency of interest charges
forvalues i = 1/2 {
	egen netbenefitbins = cut(netbenefit111`i'), at(-22000(20)16000)
	quietly: tabout netbenefitbins if idtag==1 [aw=w1] using ".\Excel output\Appendix B5.xls", f(4) c(col) append
	drop netbenefitbins
	}
	
